@app.route("/export_path_unused", methods=['GET'])
def export_path_unused():
    paths = [
        '',
        'home',
        'users',
        'users/details/*/*',
        'users/edit/*',
        'users/groups/*',
        'users/set-password/*',
        'users/add',
        'users/cases/*',
        'users/user_info_controller/new/*',
        'users/user_info_controller/new/*/*',
        'payment-terms',
        'payment-terms/add',
        'payment-terms/edit/*',
        'groups',
        'groups/add',
        'groups/users/*',
        'groups/cases/users/*',
        'groups/edit/*',
        'groups/permission/*',
        'groups/case-type/*',
        'customers',
        'customers/add',
        'customers/details/*',
        'customers/details/*/*',
        'customers/edit/*',
        'customers/cases/*',
        'customers/contact/add/*',
        'customers/vcard/edit/*',
        'customers/form/edit/*',
        'customers/contact/edit/*/*',
        'customers/contact/history-contact/add/*',
        'customers/contact/history-contact/edit/*/*',
        'customers/message/*/*',
        'customers/weight/edit/*',
        'location',
        'location/industry-connect/*',
        'location/add/*',
        'location/add',
        'location/edit/*',
        'location/edit/*/*',
        'location/edit/*/*/*',
        'location/edit/*/*',
        'office-work',
        'timeline',
        'timeline/add',
        'timeline/add/company',
        'timeline/edit-company-event/*',
        'timeline/edit/*/*',
        'vacation-request',
        'cases',
        'cases-bilans',
        'cases-creator',
        'cases/add',
        'cases/details/*',
        'cases/edit/*',
        'cases/retry/*',
        'cases/restore',
        'cases/return/*',
        'forward-cases',
        'my-cases',
        'cost-cases-planner',
        'bank-transfer-details',
        'currency-list',
        'currency-list/add',
        'currency-list/edit/*',
        'deleted-purchase-invoices',
        'invoice-list',
        'pucharse-invoices-responsible-users',
        'invoice-list/add',
        'invoice-list/add/*',
        'invoice-list/edit/*',
        'invoice-list/details/*/*',
        'invoice-list/return/*',
        'sells-invoice',
        'sells-invoice/client/*',
        'sells-invoice/unpaid-invoices-report/*/*',
        'warehouse',
        'project',
        'permissions',
        'permissions/add',
        'permissions/edit/*',
        'spare-parts',
        'spare-parts/add',
        'spare-parts/add/*',
        'spare-parts/edit/*',
        'spare-parts/details/*',
        'sells-invoice/add',
        'sells-invoice/add/*',
        'sells-invoice/edit/*',
        'sells-invoice/correction/*',
        'project',
        'project/add',
        'project/add/user/*',
        'project/edit/*',
        'project/stage/add/*',
        'project/stage/edit/*',
        'settlements',
        'settlements-montly',
        'settlements/add',
        'settlements/add/*',
        'settlements/edit/*',
        'settlements/default-edit/*',
        'delegation',
        'delegation/add/*',
        'delegation/edit/*',
        'monitor',
        'marketing-monitor',
        'ticket',
        'users-vacation',
        'users-employments',
        'procedures',
        'procedures/*',
        'acceptance',
        'past-contacts',
        'future-contacts',
        'purchase',
        'issues',
        'change-password',
        'work-cards',
        'office-equipment',
        'my-vacation-request',
        'budget-planner',
        'port-calls-ship/*',
        'port-calls-port/*',
        'port-calls',
        'port-calls-port/*',
        'port-calls-ship/*',
        'monitor-case-invoices',
        'documents',
        'delegations',
        'delegations-national',
        'delegations-national-add',
        'delegations-national-edit/*',
        'delegations-national-add-settlements/*',
        'delegations-national-edit-settlements/*',
        'delegations-foreign',
        'delegations-foreign-add',
        'delegations-foreign-edit/*',
        'delegations-foreign-add-settlements/*',
        'delegations-foreign-edit-settlements/*',
        'delegations-users',
        'delegations-users-add',
        'delegations-users-edit/*',
        'delegations-fleet-company',
        'delegations-fleet-company-add',
        'delegations-fleet-company-edit/*',
        'delegations-fleet-other',
        'delegations-fleet-other-add',
        'delegations-fleet-other-edit/*',
        'delegations-acceptance-path',
        'delegations-acceptance-path-add',
        'delegations-advances',
        'delegations-advances/*/*',
        'delegations-advances-add',
        'financial-statistics',
        'financial-statistics/generating-expenses/*/*/*',
        'financial-statistics/generating-profits/*/*/*',
        'financial-statistics/generating-balance/*/*/*',
        'l4verification',
        'timeline-service',
        'warehouse-office-equipment',
        'warehouse-clothes',
        'warehouse-office-equipment/edit/*',
        'warehouse-office-equipment/addrequest',
        'warehouse-office-equipment/addset',
        'warehouse-office-equipment/editset/*',
        'warehouse-clothes/add',
        'warehouse-clothes/add-self',
        'warehouse-clothes/addrequest',
        'warehouse-clothes/edit/*',
        'warehouse-clothes/editUserrequest/*',
        'warehouse-clothes/editLogisticrequest/*',
        'warehouse-office-equipment/editUserrequest/*',
        'warehouse-office-equipment/editLogisticrequest/*',
        'purchase-order',
        'purchase-order/add/*',
        'purchase-order/add',
        'purchase-order/edit/*',
        'info-notify'
    ]

    query = """SELECT distinct(url) FROM user_logs where user_id not in (181,77,316,326,144, 42);"""
    df = pd.read_sql(query, db.session.bind)
    import fnmatch

    def match_path(path, patterns):
        for pattern in patterns:
            if fnmatch.fnmatch(path, f'/{pattern}'):
                return pattern
        return None

    df['matched_pattern'] = df['url'].apply(lambda x: match_path(x, paths))

    matched_patterns = df['matched_pattern'].dropna().unique()

    all_patterns = set(paths)

    unmatched_patterns = all_patterns - set(matched_patterns)
    sorted_unmatched_patterns = sorted(unmatched_patterns)

    print("Wzorce, które nie zostały przypisane:")
    for row in sorted_unmatched_patterns:
        print(row)

    return df
